/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.TabbedPane;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;

public class DefaultLookAndFeel
extends LookAndFeel
implements FocusListener {
    private Image[] chkBoxImages = null;
    private Image comboImage = null;
    private Image[] rButtonImages = null;
    private boolean tickWhenFocused = true;

    public void bind(Component cmp) {
        if (this.tickWhenFocused && cmp instanceof Label) {
            ((Label)cmp).addFocusListener(this);
        }
    }

    public void setTickWhenFocused(boolean tickWhenFocused) {
        this.tickWhenFocused = tickWhenFocused;
    }

    public void setCheckBoxImages(Image checked, Image unchecked) {
        this.chkBoxImages = checked == null || unchecked == null ? null : new Image[]{unchecked, checked};
    }

    public void setComboBoxImage(Image picker) {
        this.comboImage = picker;
    }

    public void setRadioButtonImages(Image selected, Image unselected) {
        this.rButtonImages = selected == null || unselected == null ? null : new Image[]{unselected, selected};
    }

    public Image[] getRadioButtonImages() {
        return this.rButtonImages;
    }

    public Image[] getCheckBoxImages() {
        return this.chkBoxImages;
    }

    public void drawButton(Graphics g, Button b) {
        this.drawComponent(g, b, b.getIconFromState(), null, 0);
    }

    public void drawCheckBox(Graphics g, Button cb) {
        if (this.chkBoxImages != null) {
            this.drawComponent(g, cb, cb.getIconFromState(), this.chkBoxImages[cb.isSelected() ? 1 : 0], 0);
        } else {
            Style style = cb.getStyle();
            int height = cb.getStyle().getFont().getHeight();
            this.drawComponent(g, cb, cb.getIconFromState(), null, height);
            g.setColor(style.getFgColor());
            int gradientColor = style.getBgColor();
            int width = height;
            int rectWidth = DefaultLookAndFeel.scaleCoordinate(12.0f, 16.0f, width);
            int tX = cb.getX();
            tX = cb.isRTL() ? tX + cb.getWidth() - style.getPadding(cb.isRTL(), 1) - rectWidth : (tX += style.getPadding(cb.isRTL(), 1));
            int tY = cb.getY() + style.getPadding(false, 0) + (cb.getHeight() - style.getPadding(false, 0) - style.getPadding(false, 2)) / 2 - height / 2;
            g.translate(tX, tY);
            int x = DefaultLookAndFeel.scaleCoordinate(1.04f, 16.0f, width);
            int y = DefaultLookAndFeel.scaleCoordinate(4.0f, 16.0f, height);
            int rectHeight = DefaultLookAndFeel.scaleCoordinate(12.0f, 16.0f, height);
            int destColor = this.findDestColor(gradientColor);
            g.fillLinearGradient(gradientColor, destColor, x + 1, y + 1, rectWidth - 2, rectHeight - 1, false);
            g.drawRoundRect(x, y, rectWidth, rectHeight, 5, 5);
            if (cb.isSelected()) {
                int color = g.getColor();
                g.setColor(0x111111);
                g.translate(0, 1);
                DefaultLookAndFeel.fillCheckbox(g, width, height);
                g.setColor(color);
                g.translate(0, -1);
                DefaultLookAndFeel.fillCheckbox(g, width, height);
            }
            g.translate(-tX, -tY);
        }
    }

    private static void fillCheckbox(Graphics g, int width, int height) {
        int x1 = DefaultLookAndFeel.scaleCoordinate(2.0450494f, 16.0f, width);
        int y1 = DefaultLookAndFeel.scaleCoordinate(9.422772f, 16.0f, height);
        int x2 = DefaultLookAndFeel.scaleCoordinate(5.8675723f, 16.0f, width);
        int y2 = DefaultLookAndFeel.scaleCoordinate(13.921746f, 16.0f, height);
        int x3 = DefaultLookAndFeel.scaleCoordinate(5.8675723f, 16.0f, width);
        int y3 = DefaultLookAndFeel.scaleCoordinate(11.0f, 16.0f, height);
        g.fillTriangle(x1, y1, x2, y2, x3, y3);
        x1 = DefaultLookAndFeel.scaleCoordinate(14.38995f, 16.0f, width);
        y1 = DefaultLookAndFeel.scaleCoordinate(0.0f, 16.0f, height);
        g.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    private static int round(float x) {
        int rounded = (int)x;
        if (x - (float)rounded > 0.5f) {
            return rounded + 1;
        }
        return rounded;
    }

    private static int scaleCoordinate(float coordinate, float plain, int pixelSize) {
        return DefaultLookAndFeel.round(coordinate / plain * (float)pixelSize);
    }

    public void drawLabel(Graphics g, Label l) {
        this.drawComponent(g, l, l.getIcon(), null, 0);
    }

    public void drawRadioButton(Graphics g, Button rb) {
        if (this.rButtonImages != null) {
            this.drawComponent(g, rb, rb.getIconFromState(), this.rButtonImages[rb.isSelected() ? 1 : 0], 0);
        } else {
            Style style = rb.getStyle();
            int height = rb.getStyle().getFont().getHeight();
            this.drawComponent(g, rb, rb.getIconFromState(), null, height + rb.getGap());
            g.setColor(style.getFgColor());
            int x = rb.getX();
            x = rb.isRTL() ? x + rb.getWidth() - style.getPadding(rb.isRTL(), 1) - height : (x += style.getPadding(rb.isRTL(), 1));
            int y = rb.getY();
            g.drawArc(x, y += Math.max(0, rb.getHeight() / 2 - height / 2), height, height, 0, 360);
            if (rb.isSelected()) {
                int color = g.getColor();
                int destColor = this.findDestColor(color);
                g.fillRadialGradient(color, destColor, x + 3, y + 3, height - 5, height - 5);
            }
        }
    }

    public void drawComboBox(Graphics g, List cb) {
        int border = 2;
        Style style = cb.getStyle();
        int leftPadding = style.getPadding(cb.isRTL(), 1);
        int rightPadding = style.getPadding(cb.isRTL(), 3);
        this.setFG(g, cb);
        ListModel model = cb.getModel();
        ListCellRenderer renderer = cb.getRenderer();
        Object value = model.getItemAt(model.getSelectedIndex());
        int comboImageWidth = this.comboImage != null ? this.comboImage.getWidth() : style.getFont().getHeight();
        int cellX = cb.getX() + style.getPadding(false, 0);
        if (cb.isRTL()) {
            cellX += comboImageWidth;
        }
        if (model.getSize() > 0) {
            Component cmp = renderer.getListCellRendererComponent(cb, value, model.getSelectedIndex(), cb.hasFocus());
            cmp.setX(cellX);
            cmp.setY(cb.getY() + style.getPadding(false, 0));
            cmp.setWidth(cb.getWidth() - comboImageWidth - 2 * rightPadding - leftPadding);
            cmp.setHeight(cb.getHeight() - style.getPadding(false, 0) - style.getPadding(false, 2));
            cmp.paint(g);
        }
        g.setColor(style.getBgColor());
        int y = cb.getY();
        int height = cb.getHeight();
        int width = comboImageWidth + border;
        int x = cb.getX();
        x = cb.isRTL() ? (x += leftPadding) : (x += cb.getWidth() - comboImageWidth - rightPadding);
        if (this.comboImage != null) {
            g.drawImage(this.comboImage, x, y + height / 2 - this.comboImage.getHeight() / 2);
        } else {
            int color = g.getColor();
            int destColor = this.findDestColor(color);
            g.fillLinearGradient(g.getColor(), destColor, x, y, width, height, false);
            g.setColor(color);
            g.drawRect(x, y, width, height - 1);
            g.translate(x + 1, y + 1);
            g.setColor(0x111111);
            int x1 = DefaultLookAndFeel.scaleCoordinate(2.5652082f, 16.0f, --width);
            int y1 = DefaultLookAndFeel.scaleCoordinate(4.4753666f, 16.0f, --height);
            int x2 = DefaultLookAndFeel.scaleCoordinate(8.287269f, 16.0f, width);
            int y2 = DefaultLookAndFeel.scaleCoordinate(10.0f, 16.0f, height);
            int x3 = DefaultLookAndFeel.scaleCoordinate(13.516078f, 16.0f, width);
            int y3 = y1;
            g.fillTriangle(x1, y1, x2, y2, x3, y3);
            g.translate(-1, -1);
            g.setColor(style.getFgColor());
            g.fillTriangle(x1, y1, x2, y2, x3, y3);
            g.translate(-x, -y);
        }
    }

    private int findDestColor(int color) {
        int sourceR = color >> 16 & 0xFF;
        int sourceG = color >> 8 & 0xFF;
        int sourceB = color & 0xFF;
        if (sourceR > 128 && sourceG > 128 && sourceB > 128) {
            sourceR = Math.max(sourceR >> 1, 0);
            sourceG = Math.max(sourceG >> 1, 0);
            sourceB = Math.max(sourceB >> 1, 0);
        } else {
            if (color == 0) {
                return 0x222222;
            }
            sourceR = Math.min(sourceR << 1, 255);
            sourceG = Math.min(sourceG << 1, 255);
            sourceB = Math.min(sourceB << 1, 255);
        }
        return sourceR << 16 & 0xFF0000 | sourceG << 8 & 0xFF00 | sourceB & 0xFF;
    }

    public void drawList(Graphics g, List l) {
    }

    public void drawTextArea(Graphics g, TextArea ta) {
        this.setFG(g, ta);
        int line = ta.getLines();
        int oX = g.getClipX();
        int oY = g.getClipY();
        int oWidth = g.getClipWidth();
        int oHeight = g.getClipHeight();
        Font f = ta.getStyle().getFont();
        int fontHeight = f.getHeight();
        int align = ta.getAbsoluteAlignment();
        int leftPadding = ta.getStyle().getPadding(ta.isRTL(), 1);
        int rightPadding = ta.getStyle().getPadding(ta.isRTL(), 3);
        int topPadding = ta.getStyle().getPadding(false, 0);
        boolean shouldBreak = false;
        for (int i = 0; i < line; ++i) {
            int y;
            int x = ta.getX() + leftPadding;
            if (Rectangle.intersects(x, y = ta.getY() + topPadding + (ta.getRowsGap() + fontHeight) * i, ta.getWidth(), fontHeight, oX, oY, oWidth, oHeight)) {
                String rowText = ta.getTextAt(i);
                String displayText = "";
                if ((ta.getConstraint() & 0x10000) != 0) {
                    for (int j = 0; j < rowText.length(); ++j) {
                        displayText = displayText + "*";
                    }
                } else {
                    displayText = rowText;
                }
                switch (align) {
                    case 3: {
                        x = ta.getX() + ta.getWidth() - rightPadding - f.stringWidth(displayText);
                        break;
                    }
                    case 4: {
                        x += (ta.getWidth() - leftPadding - rightPadding - f.stringWidth(displayText)) / 2;
                    }
                }
                g.drawString(displayText, x, y);
                shouldBreak = true;
                continue;
            }
            if (shouldBreak) break;
        }
    }

    public Dimension getButtonPreferredSize(Button b) {
        return this.getPreferredSize(b, new Image[]{b.getIcon(), b.getRolloverIcon(), b.getPressedIcon()}, null);
    }

    public Dimension getCheckBoxPreferredSize(Button cb) {
        if (this.chkBoxImages != null) {
            return this.getPreferredSize(cb, new Image[]{cb.getIcon(), cb.getRolloverIcon(), cb.getPressedIcon()}, this.chkBoxImages[0]);
        }
        Dimension d = this.getPreferredSize(cb, new Image[]{cb.getIcon(), cb.getRolloverIcon(), cb.getPressedIcon()}, null);
        int checkBoxSquareSize = cb.getStyle().getFont().getHeight();
        d.setHeight(Math.max(checkBoxSquareSize, d.getHeight()));
        d.setWidth(d.getWidth() + checkBoxSquareSize + cb.getGap());
        return d;
    }

    public Dimension getLabelPreferredSize(Label l) {
        return this.getPreferredSize(l, new Image[]{l.getIcon()}, null);
    }

    private Dimension getPreferredSize(Label l, Image[] icons, Image stateImage) {
        int prefW = 0;
        int prefH = 0;
        Style style = l.getStyle();
        int gap = l.getGap();
        for (int i = 0; i < icons.length; ++i) {
            Image icon = icons[i];
            if (icon == null) continue;
            prefW = Math.max(prefW, icon.getWidth());
            prefH = Math.max(prefH, icon.getHeight());
        }
        String text = l.getText();
        Font font = style.getFont();
        if (font == null) {
            System.out.println("Missing font for " + l);
            font = Font.getDefaultFont();
        }
        if (text != null && text.length() > 0) {
            switch (l.getTextPosition()) {
                case 1: 
                case 3: {
                    prefW += font.stringWidth(text);
                    prefH = Math.max(prefH, font.getHeight());
                    break;
                }
                case 0: 
                case 2: {
                    prefW = Math.max(prefW, font.stringWidth(text));
                    prefH += font.getHeight();
                }
            }
        }
        if (stateImage != null) {
            prefW += stateImage.getWidth() + gap;
            prefH = Math.max(prefH, stateImage.getHeight());
        }
        if (icons[0] != null && text != null && text.length() > 0) {
            switch (l.getTextPosition()) {
                case 1: 
                case 3: {
                    prefW += gap;
                    break;
                }
                case 0: 
                case 2: {
                    prefH += gap;
                }
            }
        }
        if (prefH != 0) {
            prefH += style.getPadding(false, 0) + style.getPadding(false, 2);
        }
        if (prefW != 0) {
            prefW += style.getPadding(l.isRTL(), 3) + style.getPadding(l.isRTL(), 1);
        }
        return new Dimension(prefW, prefH);
    }

    public Dimension getListPreferredSize(List l) {
        int selectedWidth;
        int selectedHeight;
        Style selectedEntryStyle;
        int width = 0;
        int height = 0;
        ListModel model = l.getModel();
        int numOfcomponents = Math.max(model.getSize(), l.getMinElementHeight());
        Object prototype = l.getRenderingPrototype();
        Style unselectedEntryStyle = null;
        if (prototype != null) {
            ListCellRenderer renderer = l.getRenderer();
            Component cmp = renderer.getListCellRendererComponent(l, prototype, 0, false);
            height = cmp.getPreferredH();
            width = cmp.getPreferredW();
            unselectedEntryStyle = cmp.getStyle();
            cmp = renderer.getListCellRendererComponent(l, prototype, 0, true);
            selectedEntryStyle = cmp.getStyle();
            selectedHeight = Math.max(height, cmp.getPreferredH());
            selectedWidth = Math.max(width, cmp.getPreferredW());
        } else {
            int hightCalcComponents = Math.min(5, numOfcomponents);
            Object dummyProto = l.getRenderingPrototype();
            if (model.getSize() > 0 && dummyProto == null) {
                dummyProto = model.getItemAt(0);
            }
            ListCellRenderer renderer = l.getRenderer();
            for (int i = 0; i < hightCalcComponents; ++i) {
                Object value = i < model.getSize() ? model.getItemAt(i) : dummyProto;
                Component cmp = renderer.getListCellRendererComponent(l, value, i, false);
                unselectedEntryStyle = cmp.getStyle();
                height = Math.max(height, cmp.getPreferredH());
                width = Math.max(width, cmp.getPreferredW());
            }
            selectedEntryStyle = unselectedEntryStyle;
            selectedHeight = height;
            selectedWidth = width;
            if (model.getSize() > 0) {
                Object value = model.getItemAt(0);
                Component cmp = renderer.getListCellRendererComponent(l, value, 0, true);
                selectedHeight = Math.max(height, cmp.getPreferredH());
                selectedWidth = Math.max(width, cmp.getPreferredW());
                selectedEntryStyle = cmp.getStyle();
            }
        }
        if (unselectedEntryStyle != null) {
            selectedWidth += selectedEntryStyle.getMargin(false, 1) + selectedEntryStyle.getMargin(false, 3);
            selectedHeight += selectedEntryStyle.getMargin(false, 0) + selectedEntryStyle.getMargin(false, 2);
            width += unselectedEntryStyle.getMargin(false, 1) + unselectedEntryStyle.getMargin(false, 3);
            height += unselectedEntryStyle.getMargin(false, 0) + unselectedEntryStyle.getMargin(false, 2);
        }
        Style lStyle = l.getStyle();
        int verticalPadding = lStyle.getPadding(false, 0) + lStyle.getPadding(false, 2);
        int horizontalPadding = lStyle.getPadding(false, 3) + lStyle.getPadding(false, 1);
        if (numOfcomponents == 0) {
            return new Dimension(horizontalPadding, verticalPadding);
        }
        if (l.getOrientation() > 1) {
            int boxWidth = l.getStyle().getFont().getHeight() + 2;
            return new Dimension(boxWidth + selectedWidth + horizontalPadding, selectedHeight + verticalPadding);
        }
        if (l.getOrientation() == 0) {
            return new Dimension(selectedWidth + horizontalPadding, selectedHeight + (height + l.getItemGap()) * (numOfcomponents - 1) + verticalPadding);
        }
        return new Dimension(selectedWidth + (width + l.getItemGap()) * (numOfcomponents - 1) + horizontalPadding, selectedHeight + verticalPadding);
    }

    public Dimension getRadioButtonPreferredSize(Button rb) {
        if (this.rButtonImages != null) {
            return this.getPreferredSize(rb, new Image[]{rb.getIcon(), rb.getRolloverIcon(), rb.getPressedIcon()}, this.rButtonImages[0]);
        }
        Dimension d = this.getPreferredSize(rb, new Image[]{rb.getIcon(), rb.getRolloverIcon(), rb.getPressedIcon()}, null);
        int height = rb.getStyle().getFont().getHeight();
        d.setHeight(Math.max(height, d.getHeight()));
        d.setWidth(d.getWidth() + height + rb.getGap());
        return d;
    }

    public Dimension getTextAreaSize(TextArea ta, boolean pref) {
        int prefW = 0;
        int prefH = 0;
        Font f = ta.getStyle().getFont();
        prefW = ta.getRows() == 1 ? f.stringWidth(ta.getText()) : f.charWidth(TextArea.getWidestChar()) * ta.getColumns();
        int rows = pref ? ta.getActualRows() : ta.getLines();
        prefH = (f.getHeight() + 2) * rows;
        int columns = ta.getColumns();
        String str = "";
        for (int iter = 0; iter < columns; ++iter) {
            str = str + TextArea.getWidestChar();
        }
        if (columns > 0) {
            prefW = Math.max(prefW, f.stringWidth(str));
        }
        prefH = Math.max(prefH, rows * f.getHeight());
        return new Dimension(prefW + ta.getStyle().getPadding(false, 3) + ta.getStyle().getPadding(false, 1), prefH + ta.getStyle().getPadding(false, 0) + ta.getStyle().getPadding(false, 2));
    }

    private int reverseAlignForBidi(Component c, int align) {
        if (c.isRTL()) {
            switch (align) {
                case 3: {
                    return 1;
                }
                case 1: {
                    return 3;
                }
            }
        }
        return align;
    }

    private void drawComponent(Graphics g, Label l, Image icon, Image stateIcon, int preserveSpaceForState) {
        this.setFG(g, l);
        int gap = l.getGap();
        int stateIconSize = 0;
        int stateIconYPosition = 0;
        String text = l.getText();
        Style style = l.getStyle();
        int leftPadding = style.getPadding(l.isRTL(), 1);
        int rightPadding = style.getPadding(l.isRTL(), 3);
        Font font = style.getFont();
        int fontHeight = 0;
        if (text == null) {
            text = "";
        }
        if (text.length() > 0) {
            fontHeight = font.getHeight();
        }
        if (stateIcon != null) {
            stateIconSize = stateIcon.getWidth();
            stateIconYPosition = l.getY() + l.getStyle().getPadding(false, 0) + (l.getHeight() - l.getStyle().getPadding(false, 0) - l.getStyle().getPadding(false, 2)) / 2 - stateIconSize / 2;
            preserveSpaceForState = stateIconSize + gap;
            int tX = l.getX();
            tX = l.isRTL() ? tX + l.getWidth() - style.getPadding(l.isRTL(), 1) - stateIcon.getWidth() : (tX += style.getPadding(l.isRTL(), 1));
            g.drawImage(stateIcon, tX, stateIconYPosition);
        }
        int x = l.getX() + l.getStyle().getPadding(l.isRTL(), 1) + preserveSpaceForState;
        int y = l.getY() + l.getStyle().getPadding(false, 0);
        int align = this.reverseAlignForBidi(l, l.getAlignment());
        int textPos = this.reverseAlignForBidi(l, l.getTextPosition());
        if (align == 1) {
            switch (textPos) {
                case 1: 
                case 3: {
                    y += (l.getHeight() - (l.getStyle().getPadding(false, 0) + l.getStyle().getPadding(false, 2) + Math.max(icon != null ? icon.getHeight() : 0, fontHeight))) / 2;
                    break;
                }
                case 0: 
                case 2: {
                    y += (l.getHeight() - (l.getStyle().getPadding(false, 0) + l.getStyle().getPadding(false, 2) + (icon != null ? icon.getHeight() + gap : 0) + fontHeight)) / 2;
                }
            }
        } else if (align == 4) {
            switch (textPos) {
                case 1: 
                case 3: {
                    x += (l.getWidth() - (preserveSpaceForState + leftPadding + rightPadding + (icon != null ? icon.getWidth() : 0) + font.stringWidth(text))) / 2;
                    x = Math.max(x, l.getX() + leftPadding + preserveSpaceForState);
                    y += (l.getHeight() - (style.getPadding(false, 0) + style.getPadding(false, 2) + Math.max(icon != null ? icon.getHeight() : 0, fontHeight))) / 2;
                    break;
                }
                case 0: 
                case 2: {
                    x += (l.getWidth() - (preserveSpaceForState + leftPadding + rightPadding + Math.max(icon != null ? icon.getWidth() : 0, font.stringWidth(text)))) / 2;
                    x = Math.max(x, l.getX() + leftPadding + preserveSpaceForState);
                    y += (l.getHeight() - (style.getPadding(false, 0) + style.getPadding(false, 2) + (icon != null ? icon.getHeight() + gap : 0) + fontHeight)) / 2;
                }
            }
        } else if (align == 3) {
            switch (textPos) {
                case 1: 
                case 3: {
                    x = l.getX() + l.getWidth() - rightPadding - ((icon != null ? icon.getWidth() + gap : 0) + font.stringWidth(text));
                    x = l.isRTL() ? Math.max(x - preserveSpaceForState, l.getX() + leftPadding) : Math.max(x, l.getX() + leftPadding + preserveSpaceForState);
                    y += (l.getHeight() - (style.getPadding(false, 0) + style.getPadding(false, 2) + Math.max(icon != null ? icon.getHeight() : 0, fontHeight))) / 2;
                    break;
                }
                case 0: 
                case 2: {
                    x = l.getX() + l.getWidth() - rightPadding - Math.max(icon != null ? icon.getWidth() : 0, font.stringWidth(text));
                    x = Math.max(x, l.getX() + leftPadding + preserveSpaceForState);
                    y += (l.getHeight() - (style.getPadding(false, 0) + style.getPadding(false, 2) + (icon != null ? icon.getHeight() + gap : 0) + fontHeight)) / 2;
                }
            }
        }
        int textSpaceW = l.getWidth() - style.getPadding(false, 3) - style.getPadding(false, 1);
        if (icon != null && (textPos == 3 || textPos == 1)) {
            textSpaceW -= icon.getWidth();
        }
        textSpaceW = stateIcon != null ? (textSpaceW -= stateIcon.getWidth()) : (textSpaceW -= preserveSpaceForState);
        if (icon == null) {
            this.drawLabelString(g, l, text, x, y, textSpaceW, preserveSpaceForState);
        } else {
            int strWidth = l.getStyle().getFont().stringWidth(text);
            int iconWidth = icon.getWidth();
            int iconHeight = icon.getHeight();
            switch (textPos) {
                case 1: {
                    if (iconHeight > fontHeight) {
                        int iconStringHGap = (iconHeight - fontHeight) / 2;
                        strWidth = this.drawLabelStringValign(g, l, text, x, y, iconStringHGap, iconHeight, textSpaceW, fontHeight, preserveSpaceForState);
                        g.drawImage(icon, x + strWidth + gap, y);
                        break;
                    }
                    int iconStringHGap = (fontHeight - iconHeight) / 2;
                    strWidth = this.drawLabelString(g, l, text, x, y, textSpaceW, preserveSpaceForState);
                    g.drawImage(icon, x + strWidth + gap, y + iconStringHGap);
                    break;
                }
                case 3: {
                    if (iconHeight > fontHeight) {
                        int iconStringHGap = (iconHeight - fontHeight) / 2;
                        g.drawImage(icon, x, y);
                        this.drawLabelStringValign(g, l, text, x + iconWidth + gap, y, iconStringHGap, iconHeight, textSpaceW, fontHeight, preserveSpaceForState);
                        break;
                    }
                    int iconStringHGap = (fontHeight - iconHeight) / 2;
                    g.drawImage(icon, x, y + iconStringHGap);
                    this.drawLabelString(g, l, text, x + iconWidth + gap, y, textSpaceW, preserveSpaceForState);
                    break;
                }
                case 2: {
                    if (iconWidth > strWidth) {
                        int iconStringWGap = (iconWidth - strWidth) / 2;
                        g.drawImage(icon, x, y);
                        this.drawLabelString(g, l, text, x + iconStringWGap, y + iconHeight + gap, textSpaceW, preserveSpaceForState);
                        break;
                    }
                    int iconStringWGap = (Math.min(strWidth, textSpaceW) - iconWidth) / 2;
                    g.drawImage(icon, x + iconStringWGap, y);
                    this.drawLabelString(g, l, text, x, y + iconHeight + gap, textSpaceW, preserveSpaceForState);
                    break;
                }
                case 0: {
                    if (iconWidth > strWidth) {
                        int iconStringWGap = (iconWidth - strWidth) / 2;
                        this.drawLabelString(g, l, text, x + iconStringWGap, y, textSpaceW, preserveSpaceForState);
                        g.drawImage(icon, x, y + fontHeight + gap);
                        break;
                    }
                    int iconStringWGap = (Math.min(strWidth, textSpaceW) - iconWidth) / 2;
                    this.drawLabelString(g, l, text, x, y, textSpaceW, preserveSpaceForState);
                    g.drawImage(icon, x + iconStringWGap, y + fontHeight + gap);
                }
            }
        }
    }

    private int drawLabelStringValign(Graphics g, Label l, String str, int x, int y, int iconStringHGap, int iconHeight, int textSpaceW, int fontHeight, int preserveSpaceForState) {
        switch (l.getVerticalAlignment()) {
            case 0: {
                return this.drawLabelString(g, l, str, x, y, textSpaceW, preserveSpaceForState);
            }
            case 4: {
                return this.drawLabelString(g, l, str, x, y + iconHeight / 2 - fontHeight / 2, textSpaceW, preserveSpaceForState);
            }
        }
        return this.drawLabelString(g, l, str, x, y + iconStringHGap, textSpaceW, preserveSpaceForState);
    }

    private int drawLabelString(Graphics g, Label l, String text, int x, int y, int textSpaceW, int preserveSpaceForState) {
        Style style = l.getStyle();
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        g.clipRect(x, cy, textSpaceW, ch);
        if (l.isTickerRunning()) {
            if (l.getShiftText() > 0) {
                if (l.getShiftText() > textSpaceW) {
                    l.setShiftText(x - l.getX() - style.getFont().stringWidth(text));
                }
            } else if (l.getShiftText() + style.getFont().stringWidth(text) < 0) {
                l.setShiftText(textSpaceW);
            }
        }
        int drawnW = this.drawLabelText(g, l, text, x, y, textSpaceW);
        g.setClip(cx, cy, cw, ch);
        return drawnW;
    }

    protected int drawLabelText(Graphics g, Label l, String text, int x, int y, int textSpaceW) {
        int txtW;
        Font f = l.getStyle().getFont();
        if ((!l.isTickerRunning() || l.isRTL()) && (txtW = f.stringWidth(text)) > textSpaceW && textSpaceW > 0) {
            if (l.isRTL()) {
                if (!l.isTickerRunning() && l.isEndsWith3Points()) {
                    String points = "...";
                    int pointsW = f.stringWidth(points);
                    g.drawString(points, l.getShiftText() + x, y);
                    g.clipRect(pointsW + l.getShiftText() + x, y, textSpaceW - pointsW, f.getHeight());
                }
                x = x - txtW + textSpaceW;
            } else if (l.isEndsWith3Points()) {
                String points = "...";
                int index = 1;
                int widest = f.charWidth('W');
                int pointsW = f.stringWidth(points);
                while (this.fastCharWidthCheck(text, index, textSpaceW - pointsW, widest, f)) {
                    ++index;
                }
                text = text.substring(0, index - 1) + points;
            }
        }
        g.drawString(text, l.getShiftText() + x, y);
        return Math.min(f.stringWidth(text), textSpaceW);
    }

    private boolean fastCharWidthCheck(String s, int length, int width, int charWidth, Font f) {
        if (length * charWidth < width) {
            return true;
        }
        length = Math.min(s.length(), length);
        return f.substringWidth(s, 0, length) < width;
    }

    public Dimension getComboBoxPreferredSize(List cb) {
        return this.getListPreferredSize(cb);
    }

    public void drawTabbedPane(Graphics g, TabbedPane tp) {
    }

    public Component getTabbedPaneCell(final TabbedPane tp, String text, Image icon, final boolean isSelected, final boolean cellHasFocus, final Style cellStyle, final Style cellSelectedStyle, final Style tabbedPaneStyle, final int cellOffsetX, final int cellOffsetY, final Dimension cellsPreferredSize, final Dimension contentPaneSize) {
        Label cell = new Label(text){

            public void paint(Graphics g) {
                int tPBorder = tp.getTabbedPaneBorderWidth();
                int focusMarkWidth = tPBorder * 2;
                int tabP = tp.getTabPlacement();
                if (isSelected && cellHasFocus) {
                    focusMarkWidth = tPBorder * 3;
                    this.getStyle().setFgColor(cellSelectedStyle.getFgColor());
                } else {
                    this.getStyle().setFgColor(cellStyle.getFgColor());
                }
                super.paint(g);
                if (!isSelected) {
                    g.setColor(0);
                    g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), (byte)47);
                }
                g.setColor(this.getStyle().getFgColor());
                if (tabP == 0 || tabP == 2) {
                    if (tabP == 0) {
                        if (isSelected) {
                            g.fillRect(this.getX(), this.getY() + tPBorder, this.getWidth(), focusMarkWidth);
                        }
                        g.setColor(tabbedPaneStyle.getFgColor());
                        g.fillRect(this.getX(), this.getY(), this.getWidth(), tPBorder);
                        g.fillRect(this.getX(), this.getY(), tPBorder, this.getHeight());
                    } else {
                        if (isSelected) {
                            g.fillRect(this.getX(), this.getY() + this.getHeight() - focusMarkWidth, this.getWidth(), focusMarkWidth);
                        }
                        g.setColor(tabbedPaneStyle.getFgColor());
                        g.fillRect(this.getX(), this.getY() + this.getHeight() - tPBorder, this.getWidth(), tPBorder);
                        g.fillRect(this.getX(), this.getY(), tPBorder, this.getHeight());
                    }
                    int x = this.getX() - cellOffsetX + this.getWidth();
                    if (x == contentPaneSize.getWidth()) {
                        g.fillRect(x + cellOffsetX - tPBorder, this.getY(), tPBorder, this.getHeight());
                    }
                    if (cellsPreferredSize.getWidth() < contentPaneSize.getWidth() && this.getX() + this.getWidth() == cellsPreferredSize.getWidth()) {
                        g.fillRect(this.getX() + this.getWidth() - tPBorder, this.getY(), tPBorder, this.getHeight());
                    }
                } else {
                    if (isSelected) {
                        g.fillRect(this.getX(), this.getY() + tPBorder, this.getWidth(), focusMarkWidth);
                    }
                    g.setColor(tabbedPaneStyle.getFgColor());
                    g.fillRect(this.getX(), this.getY(), this.getWidth(), tPBorder);
                    int y = this.getY() - cellOffsetY + this.getHeight();
                    if (y == contentPaneSize.getHeight()) {
                        g.fillRect(this.getX(), y + cellOffsetY - tPBorder, this.getWidth(), tPBorder);
                    }
                    if (cellsPreferredSize.getHeight() < contentPaneSize.getHeight() && this.getY() + this.getHeight() == cellsPreferredSize.getHeight()) {
                        g.fillRect(this.getX(), this.getY() + this.getHeight() - tPBorder, this.getWidth(), tPBorder);
                    }
                    if (!tp.isRTL() && tabP == 1 || tp.isRTL() && tabP == 3) {
                        g.fillRect(this.getX(), this.getY(), tPBorder, this.getHeight());
                    } else {
                        g.fillRect(this.getX() + this.getWidth() - tPBorder, this.getY(), tPBorder, this.getHeight());
                    }
                }
            }
        };
        cell.setUIID("Tab");
        cell.setCellRenderer(true);
        cell.getStyle().setBorder(null);
        cell.getStyle().setMargin(0, 0, 0, 0);
        cell.setIcon(icon);
        this.updateCellLook(tp, cell, isSelected);
        if (isSelected) {
            cellStyle.setBgColor(cellStyle.getBgColor());
        }
        cell.setAlignment(4);
        return cell;
    }

    private void updateCellLook(TabbedPane tp, Component c, boolean selected) {
        c.getStyle().setFgColor(tp.getStyle().getFgColor());
        c.getStyle().setBgTransparency(tp.getStyle().getBgTransparency());
        c.getStyle().setFont(tp.getStyle().getFont());
    }

    public void drawTabbedPaneContentPane(TabbedPane tp, Graphics g, Rectangle rect, Dimension cellsPreferredSize, int numOfTabs, int selectedTabIndex, Dimension tabsSize, int cellOffsetX, int cellOffsetY) {
        int tPBorder = tp.getTabbedPaneBorderWidth();
        if (tPBorder < 1) {
            return;
        }
        int x = rect.getX();
        int y = rect.getY();
        int w = rect.getSize().getWidth();
        int h = rect.getSize().getHeight();
        int listPreferredW = cellsPreferredSize.getWidth();
        int listPreferredH = cellsPreferredSize.getHeight();
        int maxTabWidth = tabsSize.getWidth();
        int maxTabHeight = tabsSize.getHeight();
        g.setColor(tp.getStyle().getBgColor());
        g.fillRect(x, y, w, h, tp.getStyle().getBgTransparency());
        g.setColor(tp.getStyle().getFgColor());
        int tabP = tp.getTabPlacement();
        if (tabP == 0 || tabP == 2) {
            g.fillRect(x, y, tPBorder, h);
            g.fillRect(x + w - tPBorder, y, tPBorder, h);
            int relativeY = y;
            if (tabP == 2) {
                relativeY = y + h - tPBorder;
                g.fillRect(x, y, w, tPBorder);
            } else {
                g.fillRect(x, y + h - tPBorder, w, tPBorder);
            }
            if (tp.isRTL()) {
                if (listPreferredW < w) {
                    g.fillRect(x, relativeY, w - listPreferredW, tPBorder);
                    for (int i = 0; i < numOfTabs; ++i) {
                        if (i == selectedTabIndex) continue;
                        g.fillRect(x - cellOffsetX + w - maxTabWidth * (i + 1), relativeY, maxTabWidth + tPBorder, tPBorder);
                    }
                } else {
                    for (int i = 0; i < numOfTabs; ++i) {
                        if (numOfTabs - 1 - i == selectedTabIndex) continue;
                        g.fillRect(x - cellOffsetX + maxTabWidth * i, relativeY, maxTabWidth + tPBorder, tPBorder);
                    }
                }
            } else {
                if (listPreferredW < w) {
                    g.fillRect(listPreferredW - tPBorder, relativeY, w - listPreferredW, tPBorder);
                }
                for (int i = 0; i < numOfTabs; ++i) {
                    if (i == selectedTabIndex) continue;
                    g.fillRect(x - cellOffsetX + maxTabWidth * i, relativeY, maxTabWidth + tPBorder, tPBorder);
                }
            }
        } else {
            g.fillRect(x, y, w, tPBorder);
            g.fillRect(x, y + h - tPBorder, w, tPBorder);
            int relativeX = x;
            if (!tp.isRTL() && tabP == 3 || tp.isRTL() && tabP == 1) {
                g.fillRect(x, y, tPBorder, h);
                relativeX = x + w - tPBorder;
            } else {
                g.fillRect(x + w - tPBorder, y, tPBorder, h);
            }
            if (listPreferredH < h) {
                g.fillRect(relativeX, y + listPreferredH - tPBorder, tPBorder, h - listPreferredH + tPBorder);
            }
            for (int i = 0; i < numOfTabs; ++i) {
                if (i == selectedTabIndex) continue;
                g.fillRect(relativeX, y - cellOffsetY + maxTabHeight * i, tPBorder, maxTabHeight + tPBorder);
            }
        }
    }

    protected String getTextFieldString(TextArea ta) {
        String text;
        String txt = ta.getText();
        if (ta.isSingleLineTextArea()) {
            text = txt;
        } else {
            text = ta.getTextAt(ta.getCursorY());
            if (ta.getCursorPosition() + text.length() < txt.length()) {
                char c = txt.charAt(ta.getCursorPosition() + text.length());
                if (c == '\n') {
                    text = text + "\n";
                } else if (c == ' ') {
                    text = text + " ";
                }
            }
        }
        String displayText = "";
        if ((ta.getConstraint() & 0x10000) != 0) {
            if (ta.isPendingCommit()) {
                if (text.length() > 0) {
                    for (int j = 0; j < text.length() - 1; ++j) {
                        displayText = displayText + "*";
                    }
                    displayText = displayText + text.charAt(text.length() - 1);
                }
            } else {
                for (int j = 0; j < text.length(); ++j) {
                    displayText = displayText + "*";
                }
            }
        } else {
            displayText = text;
        }
        return displayText;
    }

    public void drawTextField(Graphics g, TextArea ta) {
        this.setFG(g, ta);
        String displayText = this.getTextFieldString(ta);
        Style style = ta.getStyle();
        int x = 0;
        int cursorCharPosition = ta.getCursorX();
        Font f = ta.getStyle().getFont();
        int cursorX = 0;
        int xPos = 0;
        int align = ta.getAbsoluteAlignment();
        int displayX = 0;
        String inputMode = ta.getInputMode();
        int inputModeWidth = f.stringWidth(inputMode);
        if (ta.isQwertyInput() || Display.getInstance().isVirtualKeyboardShowing()) {
            inputMode = "";
            inputModeWidth = 0;
        }
        if (ta.isSingleLineTextArea()) {
            if (align == 1) {
                if (cursorCharPosition > 0) {
                    xPos = f.stringWidth(displayText.substring(0, cursorCharPosition));
                    cursorX = ta.getX() + style.getPadding(ta.isRTL(), 1) + xPos;
                    if (inputModeWidth > 0 && ta.getInputModeOrder() != null && ta.getInputModeOrder().length == 1) {
                        inputModeWidth = 0;
                    }
                    if (ta.isEnableInputScroll() && ta.getWidth() > f.getHeight() * 2 && cursorX >= ta.getWidth() - inputModeWidth - style.getPadding(ta.isRTL(), 1)) {
                        while (x + xPos >= ta.getWidth() - inputModeWidth - style.getPadding(ta.isRTL(), 1) * 2) {
                            --x;
                        }
                    }
                }
                displayX = ta.getX() + x + style.getPadding(ta.isRTL(), 1);
            } else {
                x = 0;
                cursorX = this.getTextFieldCursorX(ta);
                int baseX = ta.getX() + style.getPadding(false, 1) + inputModeWidth;
                int endX = ta.getX() + ta.getWidth() - style.getPadding(false, 3);
                if (cursorX < baseX) {
                    x = baseX - cursorX;
                } else if (cursorX > endX) {
                    x = endX - cursorX;
                }
                displayX = ta.getX() + ta.getWidth() - style.getPadding(false, 3) - f.stringWidth(displayText) + x;
            }
            g.drawString(displayText, displayX, ta.getY() + style.getPadding(false, 0));
        } else {
            this.drawTextArea(g, ta);
        }
        if (inputModeWidth > 0 && ta.getInputModeOrder() != null && ta.getInputModeOrder().length > 1 && ta.handlesInput() && ta.getWidth() / 2 > inputModeWidth) {
            int drawXPos = ta.getX() + style.getPadding(ta.isRTL(), 1);
            if (!ta.isRTL() && ta.getAlignment() == 1 || ta.isRTL() && ta.getAlignment() == 3) {
                drawXPos = drawXPos + ta.getWidth() - inputModeWidth - style.getPadding(false, 3) - style.getPadding(false, 1);
            }
            g.setColor(style.getFgColor());
            int inputIndicatorY = ta.getY() + ta.getScrollY() + ta.getHeight() - style.getPadding(false, 2) - f.getHeight();
            g.fillRect(drawXPos, inputIndicatorY, inputModeWidth, f.getHeight(), (byte)-116);
            g.setColor(style.getBgColor());
            g.drawString(inputMode, drawXPos, inputIndicatorY);
        }
    }

    private boolean isRTLOrWhitespace(char c) {
        return Display.getInstance().isRTL(c) || c == ' ';
    }

    private int getTextFieldCursorX(TextArea ta) {
        Style style = ta.getStyle();
        Font f = style.getFont();
        String displayText = this.getTextFieldString(ta);
        String inputMode = ta.getInputMode();
        int inputModeWidth = f.stringWidth(inputMode);
        if (ta.isQwertyInput() || Display.getInstance().isVirtualKeyboardShowing()) {
            inputMode = "";
            inputModeWidth = 0;
        }
        int xPos = 0;
        int cursorCharPosition = ta.getCursorX();
        int cursorX = 0;
        int x = 0;
        if (ta.getAbsoluteAlignment() == 3) {
            if (Display.getInstance().isBidiAlgorithm()) {
                cursorCharPosition = Display.getInstance().getCharLocation(displayText, cursorCharPosition - 1);
                if (cursorCharPosition == -1) {
                    xPos = f.stringWidth(displayText);
                } else {
                    displayText = Display.getInstance().convertBidiLogicalToVisual(displayText);
                    if (!this.isRTLOrWhitespace(displayText.charAt(cursorCharPosition))) {
                        ++cursorCharPosition;
                    }
                    xPos = f.stringWidth(displayText.substring(0, cursorCharPosition));
                }
            }
            int displayX = ta.getX() + ta.getWidth() - style.getPadding(ta.isRTL(), 1) - f.stringWidth(displayText);
            cursorX = displayX + xPos;
            x = 0;
        } else {
            if (cursorCharPosition > 0) {
                cursorCharPosition = Math.min(displayText.length(), cursorCharPosition);
                xPos = f.stringWidth(displayText.substring(0, cursorCharPosition));
            }
            cursorX = ta.getX() + style.getPadding(ta.isRTL(), 1) + xPos;
            if (ta.isSingleLineTextArea() && ta.getWidth() > f.getHeight() * 2 && cursorX >= ta.getWidth() - inputModeWidth - style.getPadding(ta.isRTL(), 1)) {
                while (x + xPos >= ta.getWidth() - inputModeWidth - style.getPadding(false, 1) - style.getPadding(false, 3)) {
                    --x;
                }
            }
        }
        return cursorX + x;
    }

    public Dimension getTextFieldPreferredSize(TextArea ta) {
        return this.getTextAreaSize(ta, true);
    }

    public void drawTextFieldCursor(Graphics g, TextArea ta) {
        Style style = ta.getStyle();
        Font f = style.getFont();
        int cursorY = ta.getY() + style.getPadding(false, 0) + ta.getCursorY() * (ta.getRowsGap() + f.getHeight());
        int cursorX = this.getTextFieldCursorX(ta);
        int align = ta.getAbsoluteAlignment();
        int x = 0;
        if (align == 3) {
            String inputMode = ta.getInputMode();
            int inputModeWidth = f.stringWidth(inputMode);
            int baseX = ta.getX() + style.getPadding(false, 1) + inputModeWidth;
            if (cursorX < baseX) {
                x = baseX - cursorX;
            }
        }
        int oldColor = g.getColor();
        g.setColor(style.getFgColor());
        g.drawLine(cursorX + x, cursorY, cursorX + x, cursorY + f.getHeight());
        g.setColor(oldColor);
    }

    public void focusGained(Component cmp) {
        Label l;
        if (cmp instanceof Label && (l = (Label)cmp).isTickerEnabled() && l.shouldTickerStart()) {
            ((Label)cmp).startTicker(this.getTickerSpeed(), true);
        }
    }

    public void focusLost(Component cmp) {
        Label l;
        if (cmp instanceof Label && (l = (Label)cmp).isTickerRunning()) {
            l.stopTicker();
        }
    }
}

